%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SHARK-FV 2025 class for LaTeX files                            %%
%%                                                                %%
%% The regular article class commands still exist and may be used.%%
%% 10pt, 11pt and twocolumn options are enabled.                  %%
%%                                                                %%
%% \maketitle make the first page automatically                   %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\LoadClass[11pt,a4paper]{article}
\special{papersize=210mm,297mm}

% --------------------------------------------------
% Required packages
% --------------------------------------------------
\RequirePackage{times}      % Loads the Times-Roman Fonts
\RequirePackage{mathptmx}   % Loads the Times-Roman Math Fonts
\usepackage{caption}
\usepackage{graphicx}
\usepackage{amsmath}
\usepackage{amssymb}
\usepackage{amsfonts}
\usepackage{amsthm}
\usepackage{multicol}
\usepackage{tabularx}
\usepackage{latexsym}
\usepackage[usenames,dvipsnames]{xcolor}
\usepackage[T1]{fontenc}
\usepackage{varwidth}

% --------------------------------------------------
% New Commands & color
% --------------------------------------------------
\definecolor{Gshark}{rgb}{0.0 0.0 0.3}

\renewcommand*{\thefootnote}{\fnsymbol{footnote}}


% --------------------------------------------------
% Page dimensions and definitions
% --------------------------------------------------
% Refer to http://en.wikibooks.org/wiki/LaTeX/Page_Layout for details
\setlength\headsep{0mm}
\setlength\footskip{0mm}
\setlength\hoffset{-1in}
\setlength\voffset{-1in}
\setlength\headheight{0mm}
\setlength\marginparsep{0mm}
\setlength\marginparpush{0mm}
\setlength\marginparwidth{0mm}
% The commands above allows to work in the full paper, ie without any preset lengths
\setlength\textwidth{170mm}
\setlength\textheight{257mm}
\setlength\topmargin{20mm}
\setlength\oddsidemargin{20.0mm}

% --------------------------------------------------
% "TITLE PAGE"
% --------------------------------------------------
\renewcommand{\maketitle}{

   \thispagestyle{empty}
   % --------------------------------------------------
   % Conference Title
   % --------------------------------------------------
   \begin{minipage}{0.99\textwidth}
       \begin{center}
%          \normalsize{\colorbox{dgray}{\textcolor{white}{\textsf{\textbf{Silver SHARK-FV --- May 21-25 2018 --- 	Minho, Portugal.}}}}}\\
%          \normalsize{\colorbox{dgray}{\textcolor{white}{\textsf{{Sharing Higher-order Advanced Research Know-how on Finite Volumes}}}}}
         %\vspace{-1.75cm}
         \includegraphics[width=0.99\textwidth]{Coimbra_banner_small}
       \end{center}
   \end{minipage}
   % \hspace*{0.02\textwidth}
   %\begin{minipage}{0.08\textwidth}
      %\vspace{-2.8mm}\includegraphics[width=\textwidth]{logo}
   %\end{minipage}

   % --------------------------------------------------
   % TITLE, AUTHORS AND AFFILIATIONS
   % --------------------------------------------------
   \begin{raggedright}%
      {
         \vspace{15mm}
         \fontsize{14}{16}\selectfont

         %{\colorbox{dgray}{
         %    \begin{varwidth}{\dimexpr \linewidth-2 \fboxsep}
         %    {\color{white}
         %   \bfseries\sffamily\MakeUppercase \@title} \end{varwidth}
         %   }

            {\colorbox{Gshark}{
             \begin{varwidth}{\dimexpr \linewidth-2 \fboxsep}
             {\color{white}
            \bfseries\sffamily\MakeUppercase \@title} \end{varwidth}
            }
         }\par
      }
      \vspace{5mm}%
      {
         \fontsize{12}{14}\selectfont
         \@author
         \par
      }
      \vspace{2mm}%
      {
         \fontsize{10}{12}\selectfont
         \normalfont\@address
         \par
      }
   \end{raggedright}

   \vspace{10mm}

   % --------------------------------------------------
   % ABSTRACT
   % --------------------------------------------------
   \begin{center}
      \begin{minipage}{0.95\textwidth}
         \begin{center}
            %{\colorbox{orange}{
            % \begin{varwidth}{\dimexpr \linewidth-2 \fboxsep}
            % {\color{black}
            %\bfseries\sffamily\MakeUppercase \@title} \end{varwidth}
            %}
            {\color{white}
            \noindent{\normalsize\bfseries\sffamily \colorbox{Gshark}{ABSTRACT} \\}
        }
            \par
         \end{center}
            \@abstract
      \end{minipage}
   \end{center}
   \vspace{5mm}
}




% --------------------------------------------------
% NEW COMMANDS AND DEFINITIONS
% --------------------------------------------------
\def\author{\@ifnextchar[{\@getshortauthor}{\@getauthor}}
\def\@getauthor#1{\gdef\@author{#1}\gdef\@shortauthor{#1}}
\def\@getshortauthor[#1]#2{\gdef\@shortauthor{#1}\gdef\@author{#2}}

\newcommand{\address}[1]{\gdef\@address{#1}}
\newcommand{\dates}[1]{\gdef\@dates{#1}}
\newcommand{\corres}[1]{\footnote{Correspondence to #1}}
\renewcommand{\abstract}[1]{\gdef\@abstract{#1}}
\newcommand{\heading}[1]{\gdef\@heading{#1}}


% --------------------------------------------------
% Headings (header, footer and banners)
% --------------------------------------------------
\def\ps@myheadings{%
   \def\@oddfoot{\normalfont\hfil\hfil}
   \let\@evenfoot\@oddfoot
   \let\@oddhead\@evenhead
   \let\@mkboth\@gobbletwo
   \let\sectionmark\@gobble
   \let\subsectionmark\@gobble
}

% --------------------------------------------------
% STYLE OF SECTIONS AND CAPTION
% --------------------------------------------------
% \renewcommand\typeofsection{\@startsection {typeofsection}{level in toc}{indent}{space before}{space after}{textstyle}}

\renewcommand\section{\@startsection{section}{1}{0mm}{5mm}{1.5mm}{\normalsize\bfseries\sffamily\MakeUppercase}}%\scshape}}

\renewcommand{\subsection}{\@startsection{subsection}{2}{0mm}{3mm}{1.5mm}{\normalsize\sffamily\bfseries}}

\renewcommand{\subsubsection}{\@startsection{subsubsection}{3}{0mm}{2mm}{1.5mm}{\normalsize\sffamily\bfseries}}

\captionsetup{labelfont={sf,bf}, figurename=FIGURE, tablename=TABLE}


% --------------------------------------------------
% THE BIBLIOGRAPHY ENVIRONMENT
% --------------------------------------------------
\renewenvironment{thebibliography}[1]
   {
   \section*{\MakeUppercase\refname\@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
   \list{\@biblabel{\@arabic\c@enumiv}}%
        {\settowidth\labelwidth{\@biblabel{#1}}%
         \leftmargin\labelwidth
         \advance\leftmargin\labelsep
         \@openbib@code
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
   \sloppy
   \clubpenalty4000
   \@clubpenalty \clubpenalty
   \widowpenalty4000%
   \sfcode`\.\@m}
   {\def\@noitemerr
   {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist}

% --------------------------------------------------
% Space and intentation definitions
% --------------------------------------------------
\setlength{\textfloatsep}{12pt}
\setlength{\abovedisplayskip}{6pt}
\setlength{\belowdisplayskip}{6pt}
\setlength{\parindent}{5mm}
\setlength{\abovecaptionskip}{6pt}
\setlength{\belowcaptionskip}{6pt}
\setlength{\itemsep}{0pt}
%\addtolength{\parskip}{2mm} %gilac

% --------------------------------------------------
% Final commands
% --------------------------------------------------
\AtBeginDocument{%
  \pagestyle{myheadings}
  \maketitle
  \let\maketitle\relax
  \flushbottom
}

\endinput
